/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverestore;

import com.ibm.hwmca.base.upgrddat.UpgradeDataConstants;
import com.ibm.hwmca.base.upgrddat.UpgradeDataErrorIds;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.upgrddat.UpgradeData;
import com.ibm.hwmca.fw.upgrddat.UpgradeDataException;
import com.ibm.hwmca.fw.util.BinaryNumber;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class UpgradeSimData
implements UpgradeData,
UpgradeDataErrorIds,
UpgradeDataConstants {
    private static final String TRACE_MASKT = "XSAVSMLT";
    private static final String TRACE_MASKF = "XSAVSMLF";
    private static final String TRACE_MASKD = "XSAVSMLD";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(3, "UpgradeSimData");
    public final String traceFileName = "UpgradeDataTrace.lst";
    protected String file;
    protected String versionNumber;
    protected String traceFile;

    public UpgradeSimData() throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradeSimData() Constructor");
        try {
            this.file = "UpgradeSim.trm";
            this.file = BaseFileControl.getFilePath("UpgradeSim.trm") + "UpgradeSim.trm";
            this.traceFile = BaseFileControl.getFilePath("UpgradeDataTrace.lst") + "UpgradeDataTrace.lst";
            this.versionNumber = "00001";
        }
        catch (HException exc) {
            Trace.trace(TRACE_MASKF, "An Exception occurred finding pathing for table file");
            Trace.trace(TRACE_MASKF, exc);
            UpgradeDataException hexe = new UpgradeDataException(exc);
            hexe.setCriticalDataError();
            new FrameworkLog(_logInfo, 16576, hexe).log();
            throw hexe;
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeSimData() Constructor");
    }

    public String getUpgradeDataVersion() throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradeSimData.getUpgradeDataVersion()");
        Trace.trace(TRACE_MASKF, "Version number is : " + this.versionNumber);
        Trace.trace(TRACE_MASKT, "<- UpgradeSimData.getUpgradeDataVersion()");
        return this.versionNumber;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveUpgradeData(OutputStream fileNameZip) throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradeSimData.saveUpgradeData(OutputStream StreamNameOut)");
        byte[] buf = new byte[1024];
        ZipOutputStream zos = null;
        try {
            Trace.trace(TRACE_MASKF, "File output stream passed in is : " + fileNameZip);
            Trace.trace(TRACE_MASKF, "Trace File is " + this.traceFile);
            Date date = new Date();
            FileWriter fileTrace = new FileWriter(this.traceFile, true);
            fileTrace.write("\n\nUpgradeSimData Save running\n");
            fileTrace.write("\n" + date + "\n\n");
            fileTrace.write("File stream passed in is : " + fileNameZip + "\n");
            Trace.trace(TRACE_MASKF, "Flush stream");
            fileNameZip.flush();
            try {
                try {
                    int len;
                    Trace.trace(TRACE_MASKF, "Open zip file stream");
                    zos = new ZipOutputStream(fileNameZip);
                    Trace.trace(TRACE_MASKF, "Zip file stream openned");
                    zos.setMethod(8);
                    Trace.trace(TRACE_MASKF, "Zip file parameter 1 done");
                    zos.setComment("compressed");
                    Trace.trace(TRACE_MASKF, "Zip file parameter 2 done");
                    String filepath = BaseFileControl.getFilePath("iqzzsdf.h");
                    Trace.trace(TRACE_MASKF, "sim h file path is : " + filepath);
                    String str = filepath + "iqzzsdf.h";
                    Trace.trace(TRACE_MASKF, "sim h file location is : " + str);
                    File fileobject = new File(str);
                    ZipEntry ze = new ZipEntry("iqzzsdf.h");
                    FileInputStream is = new FileInputStream(str);
                    Trace.trace(TRACE_MASKF, "str File length is : " + fileobject.length());
                    Trace.trace(TRACE_MASKF, "Zip entry created");
                    zos.putNextEntry(ze);
                    Trace.trace(TRACE_MASKF, "Entry written to zip File");
                    while ((len = is.read(buf)) >= 0) {
                        zos.write(buf, 0, len);
                    }
                    Trace.trace(TRACE_MASKF, "File " + str + " written to Zip file");
                    fileTrace.write(str + " written to zip file.\n\n");
                    is.close();
                    filepath = BaseFileControl.getFilePath("iqzzspr.dat");
                    Trace.trace(TRACE_MASKF, "sim data file path is : " + filepath);
                    str = filepath + "iqzzspr.dat";
                    Trace.trace(TRACE_MASKF, "sim data file location is : " + str);
                    fileobject = new File(str);
                    ze = new ZipEntry("iqzzspr.dat");
                    is = new FileInputStream(str);
                    Trace.trace(TRACE_MASKF, "str File length is : " + fileobject.length());
                    Trace.trace(TRACE_MASKF, "Zip entry created");
                    zos.putNextEntry(ze);
                    Trace.trace(TRACE_MASKF, "Entry written to zip File");
                    while ((len = is.read(buf)) >= 0) {
                        zos.write(buf, 0, len);
                    }
                    Trace.trace(TRACE_MASKF, "File " + str + " written to Zip file");
                    fileTrace.write(str + " written to zip file.\n\n");
                    is.close();
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException occurred zipping SIM data: " + e);
                    UpgradeDataException hexe = new UpgradeDataException(e);
                    hexe.setCriticalDataError();
                    new FrameworkLog(_logInfo, 16577, hexe).log();
                    throw hexe;
                }
                catch (HException e) {
                    Trace.trace(TRACE_MASKF, "HException while zipping Sim data");
                    UpgradeDataException hexe = new UpgradeDataException(e);
                    hexe.setCriticalDataError();
                    new FrameworkLog(_logInfo, 16578, e).log();
                    throw hexe;
                }
                Object var16_18 = null;
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                Trace.trace(TRACE_MASKF, "Doing final cleanup for try 03 block");
                fileTrace.close();
                zos.finish();
                zos.close();
                throw throwable;
            }
            Trace.trace(TRACE_MASKF, "Doing final cleanup for try 03 block");
            fileTrace.close();
            zos.finish();
            zos.close();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "Unexpected IOException occurred in UpgradeSimData: " + e);
            UpgradeDataException hexe = new UpgradeDataException(e);
            hexe.setCriticalDataError();
            new FrameworkLog(_logInfo, 16579, hexe).log();
            throw hexe;
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeSimData.saveUpgradeData(OutputStream StreamNameOut)");
    }

    public void restoreUpgradeData(InputStream streamNameIn, String versionLevel) throws UpgradeDataException {
        boolean status = false;
        byte[] readBuffer = new byte[4096];
        Trace.trace(TRACE_MASKT, "-> UpgradeSimData.restoreUpgradeData(streamName, version)");
        Trace.trace(TRACE_MASKT, "UpgradeSimData.restoreUpgradeData version is :" + versionLevel);
        try {
            String fullname;
            ZipEntry ze;
            Date date = new Date();
            FileWriter fileTrace = new FileWriter(this.traceFile, true);
            fileTrace.write("\n\nUpgradeSimData Restore Linux to Linux running\n");
            fileTrace.write("\n" + date + "\n\n");
            fileTrace.write("File stream passed in is : " + streamNameIn + "\n");
            String upgradePath = BaseFileControl.getFilePath("UpgradeDataAllTowers.zip");
            Trace.trace(TRACE_MASKF, "upgradePath is : " + upgradePath);
            ZipInputStream zis = new ZipInputStream(streamNameIn);
            while ((ze = zis.getNextEntry()) != null) {
                int bytesRead;
                String zipEntryName = ze.getName();
                Trace.trace(TRACE_MASKF, "Zip entry name is :" + zipEntryName);
                fullname = upgradePath + zipEntryName;
                Trace.trace(TRACE_MASKF, "fullname is " + fullname);
                File fileunzip = new File(fullname);
                if (fileunzip.exists()) {
                    Trace.trace(TRACE_MASKF, "file " + fullname + " exists");
                    fileunzip.delete();
                    Trace.trace(TRACE_MASKF, "file " + fullname + " deleted");
                }
                fileunzip.createNewFile();
                FileOutputStream fileOutput = new FileOutputStream(fileunzip);
                while ((bytesRead = zis.read(readBuffer)) > 0) {
                    fileOutput.write(readBuffer, 0, bytesRead);
                }
                fileOutput.close();
                Trace.trace(TRACE_MASKF, "File size written is :" + ze.getSize());
                zis.closeEntry();
            }
            Trace.trace(TRACE_MASKF, "Close zip input stream");
            zis.close();
            String filepath = BaseFileControl.getFilePath("iqzzsdf.h");
            Trace.trace(TRACE_MASKF, "sim h file path is : " + filepath);
            fullname = filepath + "iqzzsdf.h";
            Trace.trace(TRACE_MASKF, "sim h file name is : " + fullname);
            File hfile = new File(fullname);
            Trace.trace(TRACE_MASKF, "Open Buffered Reader " + fullname);
            BufferedReader newSimHfileReader = new BufferedReader(new FileReader(hfile));
            Trace.trace(TRACE_MASKF, "Buffered Reader " + fullname + " created");
            long limit = hfile.length();
            Trace.trace(TRACE_MASKF, "File size limit is " + limit);
            newSimHfileReader.mark((int)limit + 1);
            filepath = BaseFileControl.getFilePath("UpgradeDataAllTowers.zip");
            Trace.trace(TRACE_MASKF, "upgradePath is : " + filepath);
            fullname = upgradePath + "iqzzsdf.h";
            Trace.trace(TRACE_MASKF, "sim data file name is : " + fullname);
            hfile = new File(fullname);
            Trace.trace(TRACE_MASKF, "Open Buffered Reader " + fullname);
            BufferedReader oldSimHfileReader = new BufferedReader(new FileReader(hfile));
            Trace.trace(TRACE_MASKF, "Buffered Reader " + fullname + " created");
            limit = hfile.length();
            Trace.trace(TRACE_MASKF, "File size limit is " + limit);
            oldSimHfileReader.mark((int)limit + 1);
            filepath = BaseFileControl.getFilePath("UpgradeDataAllTowers.zip");
            Trace.trace(TRACE_MASKF, "upgradePath is : " + filepath);
            fullname = upgradePath + "iqzzspr.dat";
            Trace.trace(TRACE_MASKF, "sim data file name is : " + fullname);
            Trace.trace(TRACE_MASKF, "Open File Input Stream" + fullname);
            FileInputStream oldSimDatfileIn = new FileInputStream(fullname);
            Trace.trace(TRACE_MASKF, "InputStream stream " + fullname + " created");
            int fileSize = ((InputStream)oldSimDatfileIn).available();
            Trace.trace(TRACE_MASKF, "File size is " + fileSize);
            byte[] oldSimData = new byte[fileSize];
            int bytesRead = ((InputStream)oldSimDatfileIn).read(oldSimData, 0, fileSize);
            Trace.trace(TRACE_MASKF, "Bytes read is " + bytesRead);
            Trace.trace(TRACE_MASKF, "oldSimfileData is ");
            Trace.trace(TRACE_MASKF, oldSimData);
            Trace.trace(TRACE_MASKF, "Close Old Sim data stream");
            ((InputStream)oldSimDatfileIn).close();
            String path = this.file;
            Trace.trace(TRACE_MASKF, "using table file " + path + ".");
            fileTrace.write("Table name being used is : " + path + "\n\n");
            BufferedReader in = new BufferedReader(new FileReader(path));
            String line = null;
            Object newFileName = null;
            do {
                if ((line = in.readLine()) == null || (line = line.trim()).length() <= 0 || line.substring(0, 1).equals("#") || line.substring(0, 1).equals("*")) continue;
                Trace.trace(TRACE_MASKF, "Looking for sim field  [" + line + "].");
                fileTrace.write("Looking for sim field : " + line + "\n");
                short old_sim_num = this.get_field_s(oldSimHfileReader, line);
                Trace.trace(TRACE_MASKF, "Old Sim field is " + line);
                fileTrace.write("Old Sim field is " + line + "\n\n");
                Trace.trace(TRACE_MASKF, "Old sim field number is " + old_sim_num);
                fileTrace.write("Old sim field number is : " + old_sim_num + "\n\n");
                short new_sim_num = this.get_field_s(newSimHfileReader, line);
                Trace.trace(TRACE_MASKF, "New Sim field is " + line);
                fileTrace.write("New Sim field is " + line + "\n\n");
                Trace.trace(TRACE_MASKF, "New sim field number is " + new_sim_num);
                fileTrace.write("New sim field number is : " + new_sim_num + "\n\n");
                if (old_sim_num != 0 && new_sim_num != 0) {
                    Trace.trace(TRACE_MASKF, "Old and New Sim field numbers where found");
                    SimServer newSimFile = new SimServer();
                    Trace.trace(TRACE_MASKF, "Sim Server created");
                    int new_size = 0;
                    byte[] NewSimData = newSimFile.readSim(new_sim_num);
                    new_size = NewSimData.length;
                    Trace.trace(TRACE_MASKF, "New sim field size is " + new_size);
                    Trace.trace(TRACE_MASKF, "Data in NewSimData is ");
                    Trace.trace(TRACE_MASKF, NewSimData);
                    Trace.trace(TRACE_MASKF, "Call get_old_Sim_data");
                    byte[] oldDataReturned = this.get_old_Sim_data(oldSimData, old_sim_num);
                    if (oldDataReturned != null) {
                        Trace.trace(TRACE_MASKF, "oldDataReturned size is " + oldDataReturned.length);
                        Trace.trace(TRACE_MASKF, "oldDataReturned is ");
                        Trace.trace(TRACE_MASKF, oldDataReturned);
                        int old_size = oldDataReturned.length;
                        Trace.trace(TRACE_MASKF, "Old sim field size is " + old_size);
                        if (new_size == old_size) {
                            Trace.trace(TRACE_MASKF, "Old sim and new Sim field lengths are equal");
                            fileTrace.write("Old sim and new Sim field lengths are equal \n\n");
                            Trace.trace(TRACE_MASKF, "Write new sim field");
                            newSimFile.writeSim(new_sim_num, oldDataReturned);
                            Trace.trace(TRACE_MASKF, "New sim field written");
                            Trace.trace(TRACE_MASKF, "New Sim field " + line + " written");
                            fileTrace.write("New Sim field " + line + " written \n\n");
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "Old sim and new Sim field lengths are not equal");
                        fileTrace.write("Old sim and new Sim field lengths are not equal \n\n");
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "oldDataReturned is null");
                    continue;
                }
                Trace.trace(TRACE_MASKF, "No new or old sim id was not found");
                fileTrace.write("No new or old sim id was not found \n\n");
            } while (line != null);
            fileTrace.close();
            newSimHfileReader.close();
            oldSimHfileReader.close();
            ((InputStream)oldSimDatfileIn).close();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "Unexpected IOException occurred Restore Sim Data: " + e);
            UpgradeDataException hexe = new UpgradeDataException(e);
            hexe.setCriticalDataError();
            new FrameworkLog(_logInfo, 16581, hexe).log();
            throw hexe;
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "HException occurred on Restore Sim Data: " + e);
            UpgradeDataException hexe = new UpgradeDataException(e);
            hexe.setCriticalDataError();
            new FrameworkLog(_logInfo, 16580, e).log();
            throw hexe;
        }
        finally {
            Trace.trace(TRACE_MASKF, "Doing final cleanup for UpgradeSimData.restoreUpgradeData");
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeSimData.restoreUpgradeData(streamName, version)");
    }

    private short get_field_s(BufferedReader simFile, String name) {
        short field_short = 0;
        boolean found = false;
        Trace.trace(TRACE_MASKT, "-> UpgradeSimData.get_field_s()");
        try {
            Trace.trace(TRACE_MASKD, "Sim field is " + name);
            String line = null;
            Object newFileName = null;
            simFile.reset();
            do {
                if ((line = simFile.readLine()) == null || (line = line.trim()).length() <= 0 || !line.startsWith("#define")) continue;
                StringTokenizer parser = new StringTokenizer(line);
                String prefix_define = null;
                String sim_name = null;
                String field_number = null;
                int token_count = parser.countTokens();
                prefix_define = parser.nextToken();
                sim_name = parser.nextToken();
                sim_name.trim();
                field_number = parser.nextToken();
                if (!name.equals(sim_name)) continue;
                Trace.trace(TRACE_MASKD, "Sim name " + name + " found ");
                field_short = Short.parseShort(field_number);
                Trace.trace(TRACE_MASKD, "Sim number is : " + field_short);
                found = true;
            } while (line != null && !found);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "Caught IOException in UpgradeSimData.get_field_s()" + e);
            new FrameworkLog(_logInfo, 16582, e).log();
        }
        Trace.trace(TRACE_MASKD, "Field short to be returned is : " + field_short);
        Trace.trace(TRACE_MASKT, "<- UpgradeSimData.get_field_s()");
        return field_short;
    }

    private byte[] get_old_Sim_data(byte[] oldSimdata, short id) {
        boolean found = false;
        byte[] old_sim_data = null;
        byte[] sim_Id_Binary = new byte[2];
        byte[] sim_Length_Binary = new byte[2];
        short id_short = 0;
        int length_short = 0;
        int oldSimdata_length = 0;
        int count = 2;
        Trace.trace(TRACE_MASKT, "-> UpgradeSimData.get_old_Sim_data()");
        Trace.trace(TRACE_MASKD, "Creating Binary Number class");
        BinaryNumber binNum = new BinaryNumber();
        Trace.trace(TRACE_MASKD, "Binary Number Class created");
        oldSimdata_length = oldSimdata.length;
        Trace.trace(TRACE_MASKD, "Id is " + id);
        Trace.trace(TRACE_MASKD, "OldSimdata is ");
        Trace.trace(TRACE_MASKD, oldSimdata);
        Trace.trace(TRACE_MASKD, "OldSimdata length is " + oldSimdata_length);
        do {
            sim_Id_Binary[1] = oldSimdata[count++];
            sim_Id_Binary[0] = oldSimdata[count++];
            sim_Length_Binary[1] = oldSimdata[count++];
            sim_Length_Binary[0] = oldSimdata[count++];
            Trace.trace(TRACE_MASKD, "sim_Id_Binary is ");
            Trace.trace(TRACE_MASKD, sim_Id_Binary);
            Trace.trace(TRACE_MASKD, "sim_Length_Binary is ");
            Trace.trace(TRACE_MASKD, sim_Length_Binary);
            id_short = BinaryNumber.toShort(sim_Id_Binary);
            Trace.trace(TRACE_MASKD, "id_short is " + id_short);
            length_short = BinaryNumber.toShort(sim_Length_Binary);
            Trace.trace(TRACE_MASKD, "length_short is " + length_short);
            if (id_short == id) {
                Trace.trace(TRACE_MASKD, "Old sim id and sim id passed in match");
                Trace.trace(TRACE_MASKD, "Count is " + count);
                found = true;
                int size = length_short;
                Trace.trace(TRACE_MASKD, "Create old sim data length of " + size);
                old_sim_data = new byte[size];
                Trace.trace(TRACE_MASKD, "old sim data created size of " + size);
                for (int i = 0; i < length_short; ++i) {
                    old_sim_data[i] = oldSimdata[count++];
                }
            } else {
                Trace.trace(TRACE_MASKD, "Old sim id and new sim id don't match");
                Trace.trace(TRACE_MASKD, "Count is " + (count += length_short));
            }
        } while (count <= oldSimdata_length && !found);
        Trace.trace(TRACE_MASKD, "old_sim_data being returned is ");
        Trace.trace(TRACE_MASKD, old_sim_data);
        Trace.trace(TRACE_MASKD, "old_sim_data returned length is " + old_sim_data.length);
        Trace.trace(TRACE_MASKT, "<- UpgradeSimData.get_old_Sim_data()");
        return old_sim_data;
    }
}

